<?php
session_start();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Drone Game</title>
</head>
<body>
  <div id="auth">
    <h2>Connexion / Création de compte</h2>
    <input type="text" id="username" placeholder="Nom d'utilisateur">
    <input type="password" id="password" placeholder="Mot de passe">
    <br><br>
    <button id="login">Se connecter</button>
    <button id="register">Créer un compte</button>
  </div>

  <div id="connected" style="display:none;">
    <h2>Bienvenue <span id="user_name"></span> !</h2>
    <button id="join">Rejoindre la file d’attente</button>
    <button id="logout">Déconnexion</button>
  </div>

  <script>
    async function checkStatus() {
      const res = await fetch('auth.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'action=status'
      });
      const data = await res.json();

      if (data.logged_in) {
        document.getElementById('auth').style.display = 'none';
        document.getElementById('connected').style.display = 'block';
        document.getElementById('user_name').textContent = data.username;
      } else {
        document.getElementById('auth').style.display = 'block';
        document.getElementById('connected').style.display = 'none';
      }
    }

    document.getElementById('login').onclick = async () => {
      const username = document.getElementById('username').value.trim();
      const password = document.getElementById('password').value.trim();
      const res = await fetch('auth.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `action=login&username=${username}&password=${password}`
      });
      const data = await res.json();
      alert(data.message);
      checkStatus();
    };

    document.getElementById('register').onclick = async () => {
      const username = document.getElementById('username').value.trim();
      const password = document.getElementById('password').value.trim();
      const res = await fetch('auth.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `action=register&username=${username}&password=${password}`
      });
      const data = await res.json();
      alert(data.message);
      checkStatus();
    };

    document.getElementById('logout').onclick = async () => {
      await fetch('auth.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'action=logout'
      });
      checkStatus();
    };

    document.getElementById('join').onclick = async () => {
      const res = await fetch('game.php', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: 'action=join'
      });
      const data = await res.json();
      if (!data.success) {
        alert(data.message || 'Erreur');
        return;
      }
      window.location.href = 'game.html';
    };

    checkStatus();
  </script>
</body>
</html>
